// Package.java
import java.applet.*;
import java.awt.*;

public class Package {
  public int x, y;
  public final int height = 18, length = 30;
  public boolean closed;
  public ShowMobileIPCanvas canvas;
  private boolean dialogExist = false;
  public LetterDialog packageDialog;
  
  // Constructor
  public Package(int x, int y, ShowMobileIPCanvas father) {
      this.canvas = father;
      this.x=x; this.y=y;
      closed = true;
    }

    public void drawPackage(Graphics g) {
      g.setColor(Color.black);
      g.drawRect(x, y, length, height);

      g.setColor(Color.yellow);
      int[] yellowAreaX = new int[6];
      int[] yellowAreaY = new int[6];
      yellowAreaX[0] = x;    yellowAreaY[0] = y+1;
      yellowAreaX[1] = x+length; yellowAreaY[1] = y+1;
      yellowAreaX[2] = x+length; yellowAreaY[2] = y+height;
      yellowAreaX[3] = x+24; yellowAreaY[3] = y+24;
      yellowAreaX[4] = x-6;  yellowAreaY[4] = y+24;
      yellowAreaX[5] = x-6;  yellowAreaY[5] = y+6;
      g.fillPolygon(yellowAreaX, yellowAreaY, 6);

      g.setColor(Color.black);
      g.drawRect(x-6, y+6, length, height);
      g.drawLine(x, y, x-6, y+6);
      g.drawLine(x+length, y+height, x+24, y+24);
      g.drawLine(x+24, y+6, x+length, y);
      if (closed) {
	g.drawLine(x+15, y, x+9, y+6);
      }
    }

    public void erasePackage(Graphics g) {
      g.setColor(Color.lightGray);
      g.fillRect(x-7, y-2, 38, 27);
      g.fillRect(x-15, y-15, 15, 15);
      g.fillRect(x+23, y-15, 15, 15);
      //paint(g);
    }

    public void closePackage(Graphics g) {
      int i, dx, dy;
      int[] colorAreaX = new int[4];
      int[] colorAreaY = new int[4];
      dx = 15;
      dy = 15;
      for(i=22; i != -1; i--) {
    	g.setColor(Color.lightGray);
        g.fillRect(x-11, y-20, 48, 26);
	// paint(g);
	drawPackage(g);

	dx = (int) (15*Math.cos(((float) i)*Math.PI/180*5));
	dy = (int) (15*Math.sin(((float) i)*Math.PI/180*5));
	g.setColor(Color.gray);

	colorAreaX[0] = x-6;       colorAreaY[0] = y+6;
	colorAreaX[1] = x+24;      colorAreaY[1] = y+6;
	colorAreaX[2] = x+length-dx/2; colorAreaY[2] = y;
	colorAreaX[3] = x+dx/2-6;    colorAreaY[3] = y;
	g.fillPolygon(colorAreaX, colorAreaY, 4);

	if (i <= 8) {
          g.setColor(Color.yellow); 
	}
	colorAreaX[2] = x;        colorAreaY[2] = y;
	colorAreaX[3] = x-6;      colorAreaY[3] = y+6;
	colorAreaX[1] = x+dx ;    colorAreaY[1] = y-dy;
	colorAreaX[0] = x+dx-6 ;  colorAreaY[0] = y-dy+6;
	g.fillPolygon(colorAreaX, colorAreaY, 4);

	g.setColor(Color.yellow);
	colorAreaX[0] = x+length;     colorAreaY[0] = y;
	colorAreaX[1] = x+24;     colorAreaY[1] = y+6;
	colorAreaX[2] = x+24-dx;  colorAreaY[2] = y-dy+6;
	colorAreaX[3] = x+length-dx;  colorAreaY[3] = y-dy;
	g.fillPolygon(colorAreaX, colorAreaY, 4);

	g.setColor(Color.black);
      	g.drawLine(x, y, x+24-dx/2, y);
        g.drawLine(x, y, x-6, y+6);

        g.drawLine(x, y, x+dx, y-dy);
        g.drawLine(x-6, y+6, x+dx-6, y-dy+6);
	g.drawLine(x+dx, y-dy, x+dx-6, y-dy+6);

        g.drawLine(x+length, y, x+length-dx, y-dy);
        g.drawLine(x+24, y+6, x+24-dx, y-dy+6);
	g.drawLine(x+length-dx, y-dy, x+24-dx, y-dy+6);
	if (i >=8) {
          g.drawLine(x, y, x, y+6);
	}
        try {
	  Thread.sleep(Globals.sleepTime);
        } catch (InterruptedException e) {
           break;
        }
      }
      closed = true;
      // g.setColor(Color.red);
      // g.drawRect(x-6, y-11, length, 16);
    }

    public void openPackage(Graphics g) {
      int i, dx, dy;
      int[] colorAreaX = new int[4];
      int[] colorAreaY = new int[4];
      closed = false;
      dx = 15;
      dy = 15;
      for(i=0; i != 22; i++) {
    	g.setColor(Color.lightGray);
        g.fillRect(x-6, y-15, 39, 21);
	// paint(g);
	drawPackage(g);

	dx = (int) (15*Math.cos(((float) i)*Math.PI/180*5));
	dy = (int) (15*Math.sin(((float) i)*Math.PI/180*5));
	g.setColor(Color.gray);
	colorAreaX[2] = x;        colorAreaY[2] = y;
	colorAreaX[3] = x-6;      colorAreaY[3] = y+6;
	colorAreaX[1] = x+dx ;    colorAreaY[1] = y-dy;
	colorAreaX[0] = x+dx-6 ;  colorAreaY[0] = y-dy+6;
	g.fillPolygon(colorAreaX, colorAreaY, 4);

	colorAreaX[0] = x-6;       colorAreaY[0] = y+6;
	colorAreaX[1] = x+24;      colorAreaY[1] = y+6;
	colorAreaX[2] = x+length-dx/2; colorAreaY[2] = y;
	colorAreaX[3] = x+dx/2-6;    colorAreaY[3] = y;
	g.fillPolygon(colorAreaX, colorAreaY, 4);

	g.setColor(Color.yellow);
	colorAreaX[0] = x+length;     colorAreaY[0] = y;
	colorAreaX[1] = x+24;     colorAreaY[1] = y+6;
	colorAreaX[2] = x+24-dx;  colorAreaY[2] = y-dy+6;
	colorAreaX[3] = x+length-dx;  colorAreaY[3] = y-dy;
	g.fillPolygon(colorAreaX, colorAreaY, 4);

	g.setColor(Color.black);
      	g.drawLine(x, y, x+24-dx/2, y);
        g.drawLine(x, y, x-6, y+6);

        g.drawLine(x, y, x+dx, y-dy);
        g.drawLine(x-6, y+6, x+dx-6, y-dy+6);
	g.drawLine(x+dx, y-dy, x+dx-6, y-dy+6);

        g.drawLine(x+length, y, x+length-dx, y-dy);
        g.drawLine(x+24, y+6, x+24-dx, y-dy+6);
	g.drawLine(x+length-dx, y-dy, x+24-dx, y-dy+6);
	if (i >=8) {
          g.drawLine(x, y, x, y+6);
	}
        try {
	  Thread.sleep(Globals.sleepTime);
        } catch (InterruptedException e) {
           break;
        }
      }
    }

    public void letterInPackage(Graphics g, Letter2 L) {
      int i;
      for (i=L.lastY; i <= y+7; i++) {
	L.lastY = L.lastY+1;
	canvas.paint(g);
	L.drawLetter(g, L.lastX, L.lastY);

	// Erasing the letter
        if ((L.lastY == y+1) || (L.lastY == y+7)) {        
          g.setColor(Color.black);
        }
        else {
	  if (L.lastY > y+1) {
            g.setColor(Color.gray);
	  }
	  else {
	    g.setColor(Color.lightGray);
	  }
        }  
	g.drawLine(L.lastX, L.lastY-1, L.lastX+22, L.lastY-1);

      	g.setColor(Color.yellow);
	g.fillRect(x-5, y+7, 29, 16);
	//drawPackage(g);

	try {
	  Thread.sleep(Globals.sleepTime);
        } catch (InterruptedException e) {
           break;
        }
      }
    }

  public void letterOutPackage(Graphics g, Letter2 L) {
    int i;
    L.lastX = x;
    L.lastY = y+7;
    for (i=7 ; i >= -49; i--) { //(i=L.lastY; i <= y+7; i++) {
      L.lastY = L.lastY-1;
      canvas.paint(g);
      L.drawLetter(g, L.lastX, L.lastY);
      
      // Erasing the letter
      if ((L.lastY+13 == y) || (L.lastY+13 == y+6)){
	g.setColor(Color.black);
      }
      else {
	if (L.lastY+13 >= y+1) {
	  g.setColor(Color.gray);
	}
	else {
	  g.setColor(Color.lightGray);
	}
      }  
      g.drawLine(L.lastX, L.lastY+13, L.lastX+22, L.lastY+13);
      
      g.setColor(Color.yellow);
      g.fillRect(x-5, y+7, 29, 16);
      try {
	Thread.sleep(Globals.sleepTime);
      } catch (InterruptedException e) {
	break;
      }
    }
  } 
  public boolean posInPackage() {
    int lastX = x; int lastY = y;
    int x = Globals.last_x; int y = Globals.last_y;
    return((x >= lastX) && (x <= lastX + length) 
	   && (y >= lastY) && (y <=lastY + height));
  }

  public void packageDialog() {
     if (! dialogExist) {
       String info ="Encapsulation of data.\nData contains a message to MH.";
       dialogExist = true;
       packageDialog = new LetterDialog(canvas.frame, info, "Information about encapsulated data");
     }
     else {
       packageDialog.setVisible(false);
       packageDialog.show();
     }
  }
  public void closePackageDialog() {
    if (dialogExist) {
      dialogExist = false;
      packageDialog.dispose();
      packageDialog = null; 
    }
  }



}

